/**
 * Flags collected from the command line parameters
 */
export interface WebhookTriggerFlags {
    topic?: string;
    apiVersion?: string;
    deliveryMethod?: string;
    address?: string;
    clientSecret?: string;
}
export declare function collectApiVersion(apiVersion: string | undefined, availableVersions: string[]): Promise<string>;
export declare function collectTopic(topic: string | undefined, apiVersion: string, availableTopics: string[]): Promise<string>;
export declare function collectAddressAndMethod(deliveryMethod: string | undefined, address: string | undefined): Promise<[string, string]>;
export declare function collectSecret(clientSecret: string | undefined): Promise<string>;
