import { isValidURL } from '@shopify/cli-kit/common/url';
import { renderTextPrompt } from '@shopify/cli-kit/node/ui';
export async function appUrlPrompt(defaultValue) {
    return renderTextPrompt({
        message: 'App URL',
        defaultValue,
        validate: (value) => {
            if (!isValidURL(value))
                return 'Invalid URL';
        },
    });
}
export async function allowedRedirectionURLsPrompt(defaultValue) {
    const urls = await renderTextPrompt({
        message: 'Allowed redirection URLs (comma separated)',
        defaultValue,
        validate: (value) => {
            if (!value.split(',').every((url) => isValidURL(url)))
                return 'Invalid URLs';
        },
    });
    return urls.split(',');
}
//# sourceMappingURL=update-url.js.map