import { extensionTypesGroups } from '../../constants.js';
import { generateRandomNameForSubdirectory } from '@shopify/cli-kit/node/fs';
import { renderSelectPrompt, renderTextPrompt } from '@shopify/cli-kit/node/ui';
import { outputWarn } from '@shopify/cli-kit/node/output';
export function buildChoices(specifications) {
    return specifications
        .map((type) => {
        const choiceWithoutGroup = {
            label: type.externalName,
            value: type.identifier,
        };
        const group = extensionTypesGroups.find((group) => includes(group.extensions, type.identifier));
        if (group) {
            return {
                ...choiceWithoutGroup,
                group: group.name,
            };
        }
        return choiceWithoutGroup;
    })
        .sort((c1, c2) => c1.label.localeCompare(c2.label));
}
const generateExtensionPrompt = async (options) => {
    let allExtensions = options.extensionSpecifications;
    let extensionType = options.extensionType;
    let name = options.name;
    let extensionFlavor = options.extensionFlavor;
    if (!extensionType) {
        if (extensionFlavor) {
            allExtensions = allExtensions.filter((spec) => spec.supportedFlavors.map((elem) => elem.value).includes(extensionFlavor));
        }
        outputWarn(`You've reached the limit for these types of extensions: ${options.unavailableExtensions.join(', ')}\n`);
        // eslint-disable-next-line require-atomic-updates
        extensionType = await renderSelectPrompt({
            message: 'Type of extension?',
            choices: buildChoices(allExtensions),
        });
    }
    if (!name) {
        name = await renderTextPrompt({
            message: 'Extension name (internal only)',
            defaultValue: await generateRandomNameForSubdirectory({ suffix: 'ext', directory: options.directory }),
        });
    }
    const specification = options.extensionSpecifications.find((spec) => spec.identifier === extensionType);
    if (!extensionFlavor && specification.supportedFlavors.length > 1) {
        // eslint-disable-next-line require-atomic-updates
        extensionFlavor = await renderSelectPrompt({
            message: 'What would you like to work in?',
            choices: specification.supportedFlavors.map((flavor) => {
                return {
                    label: flavor.name,
                    value: flavor.value,
                };
            }),
            defaultValue: 'react',
        });
    }
    return { ...options, name, extensionType, extensionFlavor };
};
function includes(coll, el) {
    return coll.includes(el);
}
export default generateExtensionPrompt;
//# sourceMappingURL=extension.js.map