import { schema } from '@shopify/cli-kit/node/schema';
export type ZodSchemaType<T> = schema.ZodType<T, any, any>;
export declare const MetafieldSchema: schema.ZodObject<{
    namespace: schema.ZodString;
    key: schema.ZodString;
}, "strip", schema.ZodTypeAny, {
    namespace: string;
    key: string;
}, {
    namespace: string;
    key: string;
}>;
export declare const CapabilitiesSchema: schema.ZodObject<{
    network_access: schema.ZodOptional<schema.ZodBoolean>;
    block_progress: schema.ZodOptional<schema.ZodBoolean>;
    api_access: schema.ZodOptional<schema.ZodBoolean>;
}, "strip", schema.ZodTypeAny, {
    network_access?: boolean | undefined;
    block_progress?: boolean | undefined;
    api_access?: boolean | undefined;
}, {
    network_access?: boolean | undefined;
    block_progress?: boolean | undefined;
    api_access?: boolean | undefined;
}>;
export declare const TypeSchema: schema.ZodObject<{
    type: schema.ZodDefault<schema.ZodString>;
}, "strip", schema.ZodTypeAny, {
    type: string;
}, {
    type?: string | undefined;
}>;
export declare const NewExtensionPointSchema: schema.ZodObject<{
    target: schema.ZodString;
    module: schema.ZodString;
    metafields: schema.ZodOptional<schema.ZodArray<schema.ZodObject<{
        namespace: schema.ZodString;
        key: schema.ZodString;
    }, "strip", schema.ZodTypeAny, {
        namespace: string;
        key: string;
    }, {
        namespace: string;
        key: string;
    }>, "many">>;
}, "strip", schema.ZodTypeAny, {
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
    target: string;
    module: string;
}, {
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
    target: string;
    module: string;
}>;
export declare const OldExtensionPointsSchema: schema.ZodDefault<schema.ZodArray<schema.ZodString, "many">>;
export declare const NewExtensionPointsSchema: schema.ZodArray<schema.ZodObject<{
    target: schema.ZodString;
    module: schema.ZodString;
    metafields: schema.ZodOptional<schema.ZodArray<schema.ZodObject<{
        namespace: schema.ZodString;
        key: schema.ZodString;
    }, "strip", schema.ZodTypeAny, {
        namespace: string;
        key: string;
    }, {
        namespace: string;
        key: string;
    }>, "many">>;
}, "strip", schema.ZodTypeAny, {
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
    target: string;
    module: string;
}, {
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
    target: string;
    module: string;
}>, "many">;
export declare const ExtensionPointSchema: schema.ZodUnion<[schema.ZodDefault<schema.ZodArray<schema.ZodString, "many">>, schema.ZodArray<schema.ZodObject<{
    target: schema.ZodString;
    module: schema.ZodString;
    metafields: schema.ZodOptional<schema.ZodArray<schema.ZodObject<{
        namespace: schema.ZodString;
        key: schema.ZodString;
    }, "strip", schema.ZodTypeAny, {
        namespace: string;
        key: string;
    }, {
        namespace: string;
        key: string;
    }>, "many">>;
}, "strip", schema.ZodTypeAny, {
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
    target: string;
    module: string;
}, {
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
    target: string;
    module: string;
}>, "many">]>;
export declare const ApiVersionSchema: schema.ZodString;
export type ApiVersionSchemaType = schema.infer<typeof ApiVersionSchema>;
export declare const BaseUIExtensionSchema: schema.ZodObject<{
    name: schema.ZodString;
    description: schema.ZodOptional<schema.ZodString>;
    type: schema.ZodDefault<schema.ZodString>;
    apiVersion: schema.ZodOptional<schema.ZodString>;
    extensionPoints: schema.ZodOptional<schema.ZodAny>;
    capabilities: schema.ZodOptional<schema.ZodObject<{
        network_access: schema.ZodOptional<schema.ZodBoolean>;
        block_progress: schema.ZodOptional<schema.ZodBoolean>;
        api_access: schema.ZodOptional<schema.ZodBoolean>;
    }, "strip", schema.ZodTypeAny, {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    }, {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    }>>;
    metafields: schema.ZodDefault<schema.ZodOptional<schema.ZodArray<schema.ZodObject<{
        namespace: schema.ZodString;
        key: schema.ZodString;
    }, "strip", schema.ZodTypeAny, {
        namespace: string;
        key: string;
    }, {
        namespace: string;
        key: string;
    }>, "many">>>;
    categories: schema.ZodOptional<schema.ZodArray<schema.ZodString, "many">>;
}, "strip", schema.ZodTypeAny, {
    description?: string | undefined;
    apiVersion?: string | undefined;
    extensionPoints?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    } | undefined;
    categories?: string[] | undefined;
    type: string;
    metafields: {
        namespace: string;
        key: string;
    }[];
    name: string;
}, {
    type?: string | undefined;
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
    description?: string | undefined;
    apiVersion?: string | undefined;
    extensionPoints?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    } | undefined;
    categories?: string[] | undefined;
    name: string;
}>;
export declare const ThemeExtensionSchema: schema.ZodObject<{
    name: schema.ZodString;
    type: schema.ZodLiteral<"theme">;
}, "strip", schema.ZodTypeAny, {
    type: "theme";
    name: string;
}, {
    type: "theme";
    name: string;
}>;
export declare const BaseFunctionConfigurationSchema: schema.ZodObject<{
    name: schema.ZodString;
    type: schema.ZodString;
    description: schema.ZodDefault<schema.ZodOptional<schema.ZodString>>;
    build: schema.ZodObject<{
        command: schema.ZodOptional<schema.ZodEffects<schema.ZodString, string | undefined, string>>;
        path: schema.ZodOptional<schema.ZodString>;
    }, "strip", schema.ZodTypeAny, {
        path?: string | undefined;
        command?: string | undefined;
    }, {
        path?: string | undefined;
        command?: string | undefined;
    }>;
    configurationUi: schema.ZodDefault<schema.ZodOptional<schema.ZodBoolean>>;
    ui: schema.ZodOptional<schema.ZodObject<{
        enable_create: schema.ZodOptional<schema.ZodBoolean>;
        paths: schema.ZodOptional<schema.ZodObject<{
            create: schema.ZodString;
            details: schema.ZodString;
        }, "strip", schema.ZodTypeAny, {
            create: string;
            details: string;
        }, {
            create: string;
            details: string;
        }>>;
    }, "strip", schema.ZodTypeAny, {
        enable_create?: boolean | undefined;
        paths?: {
            create: string;
            details: string;
        } | undefined;
    }, {
        enable_create?: boolean | undefined;
        paths?: {
            create: string;
            details: string;
        } | undefined;
    }>>;
    apiVersion: schema.ZodString;
    input: schema.ZodOptional<schema.ZodObject<{
        variables: schema.ZodOptional<schema.ZodObject<{
            namespace: schema.ZodString;
            key: schema.ZodString;
        }, "strip", schema.ZodTypeAny, {
            namespace: string;
            key: string;
        }, {
            namespace: string;
            key: string;
        }>>;
    }, "strip", schema.ZodTypeAny, {
        variables?: {
            namespace: string;
            key: string;
        } | undefined;
    }, {
        variables?: {
            namespace: string;
            key: string;
        } | undefined;
    }>>;
}, "strip", schema.ZodTypeAny, {
    ui?: {
        enable_create?: boolean | undefined;
        paths?: {
            create: string;
            details: string;
        } | undefined;
    } | undefined;
    input?: {
        variables?: {
            namespace: string;
            key: string;
        } | undefined;
    } | undefined;
    type: string;
    name: string;
    description: string;
    apiVersion: string;
    build: {
        path?: string | undefined;
        command?: string | undefined;
    };
    configurationUi: boolean;
}, {
    description?: string | undefined;
    configurationUi?: boolean | undefined;
    ui?: {
        enable_create?: boolean | undefined;
        paths?: {
            create: string;
            details: string;
        } | undefined;
    } | undefined;
    input?: {
        variables?: {
            namespace: string;
            key: string;
        } | undefined;
    } | undefined;
    type: string;
    name: string;
    apiVersion: string;
    build: {
        path?: string | undefined;
        command?: string | undefined;
    };
}>;
export type NewExtensionPointSchemaType = schema.infer<typeof NewExtensionPointSchema>;
export type BaseConfigContents = schema.infer<typeof BaseUIExtensionSchema>;
