import { GenericSpecification } from './extensions.js';
import { AppInterface } from './app.js';
import { OutputMessage } from '@shopify/cli-kit/node/output';
export type AppLoaderMode = 'strict' | 'report';
export declare class AppErrors {
    private errors;
    addError(path: string, message: OutputMessage): void;
    getError(path: string): OutputMessage | undefined;
    isEmpty(): boolean;
    toJSON(): OutputMessage[];
}
interface AppLoaderConstructorArgs {
    directory: string;
    mode?: AppLoaderMode;
    specifications: GenericSpecification[];
}
/**
 * Load the local app from the given directory and using the provided extensions/functions specifications.
 * If the App contains extensions not supported by the current specs and mode is strict, it will throw an error.
 */
export declare function load(options: AppLoaderConstructorArgs): Promise<AppInterface>;
export declare function loadAppName(appDirectory: string): Promise<string>;
export {};
