import { schema } from '@shopify/cli-kit/node/schema';
export declare const BundleUIExtensionSchema: schema.ZodObject<{
    /** The extension UUID */
    id: schema.ZodString;
    /** The relative path to the Javascript bundle. */
    bundlePath: schema.ZodString;
}, "strip", schema.ZodTypeAny, {
    id: string;
    bundlePath: string;
}, {
    id: string;
    bundlePath: string;
}>;
export type BundleUIExtension = schema.infer<typeof BundleUIExtensionSchema>;
export declare const BundleThemeExtensionSchema: schema.ZodObject<{
    /** The extension UUID */
    id: schema.ZodString;
    /** A list of paths to the files that are part of the schema. */
    filePaths: schema.ZodArray<schema.ZodString, "many">;
}, "strip", schema.ZodTypeAny, {
    id: string;
    filePaths: string[];
}, {
    id: string;
    filePaths: string[];
}>;
export type BundleThemeExtension = schema.infer<typeof BundleThemeExtensionSchema>;
export declare const BundleFunctionExtensionSchema: schema.ZodObject<{
    /** The extension UUID */
    id: schema.ZodString;
    /** The path to the .wasm file of the function. */
    wasmPath: schema.ZodString;
}, "strip", schema.ZodTypeAny, {
    id: string;
    wasmPath: string;
}, {
    id: string;
    wasmPath: string;
}>;
export type BundleFunctionExtension = schema.infer<typeof BundleFunctionExtensionSchema>;
export declare const BundleSchema: schema.ZodObject<{
    /** The application API key */
    id: schema.ZodString;
    /** The collection of extensions that are part of the bundle */
    extensions: schema.ZodObject<{
        /** UI extensions */
        ui: schema.ZodArray<schema.ZodObject<{
            /** The extension UUID */
            id: schema.ZodString;
            /** The relative path to the Javascript bundle. */
            bundlePath: schema.ZodString;
        }, "strip", schema.ZodTypeAny, {
            id: string;
            bundlePath: string;
        }, {
            id: string;
            bundlePath: string;
        }>, "many">;
        /** Theme extensions */
        theme: schema.ZodArray<schema.ZodObject<{
            /** The extension UUID */
            id: schema.ZodString;
            /** A list of paths to the files that are part of the schema. */
            filePaths: schema.ZodArray<schema.ZodString, "many">;
        }, "strip", schema.ZodTypeAny, {
            id: string;
            filePaths: string[];
        }, {
            id: string;
            filePaths: string[];
        }>, "many">;
        /** Function extensions */
        function: schema.ZodArray<schema.ZodObject<{
            /** The extension UUID */
            id: schema.ZodString;
            /** The path to the .wasm file of the function. */
            wasmPath: schema.ZodString;
        }, "strip", schema.ZodTypeAny, {
            id: string;
            wasmPath: string;
        }, {
            id: string;
            wasmPath: string;
        }>, "many">;
    }, "strip", schema.ZodTypeAny, {
        function: {
            id: string;
            wasmPath: string;
        }[];
        theme: {
            id: string;
            filePaths: string[];
        }[];
        ui: {
            id: string;
            bundlePath: string;
        }[];
    }, {
        function: {
            id: string;
            wasmPath: string;
        }[];
        theme: {
            id: string;
            filePaths: string[];
        }[];
        ui: {
            id: string;
            bundlePath: string;
        }[];
    }>;
}, "strip", schema.ZodTypeAny, {
    extensions: {
        function: {
            id: string;
            wasmPath: string;
        }[];
        theme: {
            id: string;
            filePaths: string[];
        }[];
        ui: {
            id: string;
            bundlePath: string;
        }[];
    };
    id: string;
}, {
    extensions: {
        function: {
            id: string;
            wasmPath: string;
        }[];
        theme: {
            id: string;
            filePaths: string[];
        }[];
        ui: {
            id: string;
            bundlePath: string;
        }[];
    };
    id: string;
}>;
export type Bundle = schema.infer<typeof BundleSchema>;
