import { appFlags } from '../../../flags.js';
import metadata from '../../../metadata.js';
import Command from '../../../utilities/app-command.js';
import generate from '../../../services/generate.js';
import { Args, Flags } from '@oclif/core';
import { globalFlags } from '@shopify/cli-kit/node/cli';
import { resolvePath, cwd } from '@shopify/cli-kit/node/path';
export default class AppGenerateExtension extends Command {
    static analyticsNameOverride() {
        return 'app scaffold extension';
    }
    async run() {
        const { flags } = await this.parse(AppGenerateExtension);
        await metadata.addPublicMetadata(() => ({
            cmd_scaffold_required_auth: true,
            cmd_scaffold_template_custom: flags['clone-url'] !== undefined,
            cmd_scaffold_type_owner: '@shopify/app',
        }));
        const directory = flags.path ? resolvePath(flags.path) : cwd();
        await generate({
            directory,
            reset: flags.reset,
            apiKey: flags['api-key'],
            type: flags.type,
            name: flags.name,
            cloneUrl: flags['clone-url'],
            template: flags.template,
            config: this.config,
        });
    }
}
AppGenerateExtension.description = 'Scaffold an Extension.';
AppGenerateExtension.examples = ['<%= config.bin %> <%= command.id %>'];
AppGenerateExtension.flags = {
    ...globalFlags,
    ...appFlags,
    type: Flags.string({
        char: 't',
        hidden: false,
        description: `Extension type`,
        env: 'SHOPIFY_FLAG_EXTENSION_TYPE',
    }),
    name: Flags.string({
        char: 'n',
        hidden: false,
        description: 'name of your Extension',
        env: 'SHOPIFY_FLAG_NAME',
    }),
    'clone-url': Flags.string({
        hidden: true,
        char: 'u',
        description: 'The Git URL to clone the function extensions templates from. Defaults to: https://github.com/Shopify/function-examples',
        env: 'SHOPIFY_FLAG_CLONE_URL',
    }),
    template: Flags.string({
        hidden: false,
        description: 'Choose a starting template for your extension, where applicable',
        options: ['vanilla-js', 'react', 'typescript', 'typescript-react', 'wasm', 'rust'],
        env: 'SHOPIFY_FLAG_TEMPLATE',
    }),
    reset: Flags.boolean({
        hidden: false,
        description: 'Reset all your settings.',
        env: 'SHOPIFY_FLAG_RESET',
        default: false,
    }),
    'api-key': Flags.string({
        hidden: false,
        description: 'The API key of your app.',
        env: 'SHOPIFY_FLAG_APP_API_KEY',
    }),
};
AppGenerateExtension.args = {
    file: Args.string(),
};
//# sourceMappingURL=extension.js.map