<?php $__env->startSection('content'); ?>

 <div class="container-fluid">
    <h4 class="c-grey-900">Shopify <?php echo e($data['shop_name']); ?> Stores Orders</h4>
    <br>
    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-md-12">
        <div class="row">
            <div class="col-12">
                <div class="row">
                    <div class="col-md-3"><strong>Order Number:</strong></div>
                    <div class="col-md-9 bg-red"><?php echo e($data['order_info']->name); ?></div>
                </div>
                <br>
                <div class="row">
                    <div class="col-md-3"><strong>Created Date:</strong></div>
                    <div class="col-md-9"><?php echo e(date('Y-m-d h:i:s a', strtotime($data['order_info']->created_at))); ?></div>
                </div>
                <br>
                <hr>
                <div class="row">
                    <div class="col-md-12 text-center bg-red"><h4>Order Items Information</h4></div>
                </div>
                <hr>
                <br>
                <?php if(isset($data['order_info']->shopifyStoreOrderItem) && !empty($data['order_info']->shopifyStoreOrderItem)): ?>
                    <?php $__currentLoopData = $data['order_info']->shopifyStoreOrderItem; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderitem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($orderitem->is_pgs_store_order_id != '' && $orderitem->shopify_fulfillemnt_id == '' && $orderitem->shopify_fulfillemnt_status == ''): ?>
                            <div class="row">
                                <p class="text-center"><a href="<?php echo e(url('admin/update-order-tacking-info/'.$data['store_id'].'/'.$orderitem->id)); ?>" target="_blank">Add Tracking Info</a></p>
                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <div class="col-md-3"><strong>Item Name:</strong></div>
                            <div class="col-md-9"><?php echo e($orderitem->title); ?></div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>Quantity:</strong></div>
                            <div class="col-md-9"><?php echo e($orderitem->quantity); ?></div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>Item SKU:</strong></div>
                            <div class="col-md-9"><?php echo e($orderitem->sku); ?></div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>Item Properties:</strong></div>
                            <div class="col-md-9">
                                <?php if(!empty($orderitem->properties)): ?>
                                    <?php $propertiesData = json_decode($orderitem->properties); ?>
                                    <?php $__currentLoopData = $propertiesData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pKey => $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        
                                        <?php if($property->name == "_ Clip Art Image URL"): ?>
                                            <p> Clip Art Image - <a href="<?php echo e($property->value); ?>" target="_blank">Link</a> </p>
                                        <?php else: ?>
                                            <?php if($property->name == 'CLIPART'): ?>
                                                <p> <?php echo e($property->name); ?> - <?php echo e(CustomHelper::GetClipartReferNumber($property->value, $data['order_info']->personalised_gift_app_user_id, 'admin')); ?> </p>
                                            <?php else: ?>
                                            <p> <?php echo e($property->name); ?> - <?php echo e($property->value); ?> </p>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>Shipping Type Option:</strong></div>
                            <div class="col-md-9"><?php echo e(($orderitem->is_order_shipping_value == 1) ? "Next Day Shipping" : '--------'); ?></div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>PGS App Order ID:</strong></div>
                            <div class="col-md-9"><?php echo e(!empty($orderitem->is_pgs_store_order_id) ? $orderitem->is_pgs_store_order_id : '--------'); ?></div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>PGS APP Order Status:</strong></div>
                            <div class="col-md-9"><?php echo e(!empty($orderitem->pgs_order_status) ? ucfirst($orderitem->pgs_order_status) : '--------'); ?></div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>PGS App Tracking Id:</strong></div>
                            <div class="col-md-9"><?php echo e(!empty($orderitem->pgs_order_tracking_id) ? $orderitem->pgs_order_tracking_id : '--------'); ?></div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>PGS App Processing Time:</strong></div>
                            <div class="col-md-9"><?php echo e(!empty($orderitem->pgs_order_processed_time) ? $orderitem->pgs_order_processed_time : '--------'); ?></div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3"><strong>PGS App Shipping Services:</strong></div>
                            <div class="col-md-9"><?php echo e(!empty($orderitem->pgs_order_shipping_service) ? $orderitem->pgs_order_shipping_service : '--------'); ?></div>
                        </div>
                        <hr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                <br>
                <div class="btn-row text-center">
                    <a href="<?php echo e(url('admin/shopify-store-orders/'.$data['store_id'])); ?>" class="btn btn-primary btn-flat cstm-btn">Back</a>												
                </div>
            </div>
        </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/eux0emahe5gqllzf/public_html/app.personalisedgiftsupply.co.uk/web/resources/views/admin/stores/view-store-order.blade.php ENDPATH**/ ?>