<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="robots" content="noindex">
    <meta name="googlebot" content="noindex">

    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0,user-scalable=0" />    
    
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>Personalised Gift Supply</title>

    <link rel="canonical" href="<?php echo e(url(Request::url())); ?>" />

    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('front/images/favicon-180x180.png')); ?>">

    <!-- CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('front/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front/css/owl.carousel.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front/css/owl.theme.default.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front/css/unite-gallery.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front/css/fonts.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front/css/noty.css')); ?>">
    <?php /* <link rel="stylesheet" href="{{ asset('front/css/font-awesome.min.css') }}"> */ ?>
    <link rel="stylesheet" href="<?php echo e(asset('front/css/css2.css')); ?>">

</head>

<body>

    <?php $backgroundUrl = asset('front/images/login_banner.jpg'); ?>

    <div id="loader">
        <div class="spinner"></div>
    </div>

    <div class="login_wraper d-flex flex-wrap">
        <div class="login_left d-flex flex-wrap align-items-center justify-content-center" style='background-image:url(<?php echo e($backgroundUrl); ?>)'>
            <div class="auth_logo"><a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(asset('front/images/supply_logo.png')); ?>" alt="logo"></a></div>
        </div>

        <?php echo $__env->yieldContent('content'); ?>

    </div>
    <script src="<?php echo e(asset('front/js/jquery-3.6.0.min.js')); ?>"></script>

    <script src="<?php echo e(asset('front/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('front/js/noty.js')); ?>"></script>

    <script>

        $(".saveFormButton").on('click', function(e){
            e.preventDefault();
            $(".saveFormButton").prop('disabled', true);
            $(".saveFormButton").html('<span class="spinner-border spinner-border-sm mr-2" role="status" aria-hidden="true"></span> Submitting...');
            $("form.submitAuthForm").submit();
        });

        window.addEventListener("load", (function() {
            const t = document.getElementById("loader");
            setTimeout((function() {
                t.classList.add("fadeOut")
            }), 300)
        }));
    </script>

</body>

</html><?php /**PATH /home/eux0emahe5gqllzf/public_html/app.personalisedgiftsupply.co.uk/web/resources/views/layouts/login.blade.php ENDPATH**/ ?>