<?php $__env->startSection('content'); ?>
<style>
#storesTable tbody td {
    word-wrap: break-word!important;
    text-overflow: ellipsis;}
</style>    

 <div class="container-fluid">
    <div class="row">
        <div class="col-md-8">
            <h4 class="c-grey-900">Shopify <?php echo e($data['store_info']->shop); ?> Stores Orders</h4>
        </div>
        <div class="col-md-4">
            <div class="btn-row text-center">
                <a href="<?php echo e(url('admin/shopify-stores')); ?>" class="btn btn-primary btn-flat cstm-btn">Back</a>												
            </div>
        </div>
    </div>
    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    <input type="hidden" id="storeId" value="<?php echo e($data['store_info']->id); ?>">
    <div class="row">
        <div class="col-md-12">
            <div class="bgc-white bd bdrs-3 p-20 mB-20 table-responsive">
                <table class="table table-centered table-striped w-100 display" id="storeOrdersTable">
                    <thead>
                        <tr>
                            <th>Order Number</th>
                            <th>Created Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
    
    $('#storeOrdersTable').DataTable({
        language: {
            paginate: {
                previous: "<i class='ti-angle-left'>",
                next: "<i class='ti-angle-right'>"
            }
        },
        drawCallback: function() {
            $(".dataTables_paginate > .pagination").addClass("pagination-rounded")
        },          
        processing: true,
        serverSide: true,
        deferRender: true,
        pageLength: 20,
        lengthMenu: [20, 40, 60, 80, 100],
        ajax: {
            "url" : "<?php echo e(url('admin/ajax-shopify-store-orders')); ?>",
            "type": "GET",
            "data" : { 
                "store_id": $("#storeId").val()
            },
        },
        aaSorting : [[0, 'desc']],
        columnDefs: [{
            'targets': 'no-sort',
            'orderable': false,
        }],
        columns: [
            {
                data: 'order_number'
            },
            {
                data: 'created_at'
            },
            {
                data: 'page_action'
            }
        ],
        
    });
   
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/eux0emahe5gqllzf/public_html/app.personalisedgiftsupply.co.uk/web/resources/views/admin/stores/order-lists.blade.php ENDPATH**/ ?>