<?php $__env->startSection('content'); ?>

 <div class="container-fluid">
    <h4 class="c-grey-900">Shopify <?php echo e($data['shop_name']); ?> Stores Orders</h4>
    <br>
    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-md-12">
        <div class="row">
            <div class="col-12">
                <div class="row">
                    <div class="col-md-3"><strong>Order Number:</strong></div>
                    <div class="col-md-9 bg-red"><?php echo e($data['order_item_info']->shopifyStoreOrder->name); ?></div>
                </div>
                <br>
                <div class="row">
                    <div class="col-md-3"><strong>Created Date:</strong></div>
                    <div class="col-md-9"><?php echo e(date('Y-m-d h:i:s a', strtotime($data['order_item_info']->created_at))); ?></div>
                </div>
                <br>
                <hr>
                <form action="<?php echo e(url('admin/update-pgs-order-tracking')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-md-6">
                            <label class="form-label" for="exampleInputEmail1">Order Tracking Id <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="tracking_id" value="<?php echo e((!empty(old('tracking_id'))) ? old('tracking_id') : $data['order_item_info']->pgs_order_tracking_id); ?>" placeholder="Order Tracking Id" required>
                            <?php if($errors->has('tracking_id')): ?>
                                <div class="help-block text-danger mt-1">
                                    <span><?php echo e($errors->first('tracking_id')); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label" for="exampleInputEmail1">Order Processed Time <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="processed_time" value="<?php echo e((!empty(old('processed_time'))) ? old('processed_time') : $data['order_item_info']->pgs_order_processed_time); ?>" placeholder="Order Processed Time" required>
                            <?php if($errors->has('processed_time')): ?>
                                <div class="help-block text-danger mt-1">
                                    <span><?php echo e($errors->first('processed_time')); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                        <input type="hidden" name="order_item_id" value="<?php echo e($data['order_item_info']->id); ?>">
                        <input type="hidden" name="store_id" value="<?php echo e($data['store_id']); ?>">
                        <input type="hidden" name="order_id" value="<?php echo e($data['order_item_info']->shopify_store_order_id); ?>">
                    </div>
                    <div class="row">
                        <div class="col-md-12" style="margin-top:10px;">
                            <?php if(empty($data['order_item_info']->shopify_fulfillemnt_id)): ?>
                                <button type="submit" class="btn btn-primary btn-flat cstm-btn">Submit</button>
                            <?php endif; ?>
                            <a href="<?php echo e(url('admin/view-store-order/'.$data['store_id'].'/'.$data['order_item_info']->shopify_store_order_id)); ?>" class="btn btn-primary btn-flat cstm-btn">Back</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/eux0emahe5gqllzf/public_html/app.personalisedgiftsupply.co.uk/web/resources/views/admin/stores/update-order-tracking-info.blade.php ENDPATH**/ ?>